#ifndef TESTSHEET_H
#define TESTSHEET_H

#include <qstring.h>
#include <QVector>
#include <QStringList>

class TestSheet
{
public:
    struct pinDesignation
    {
        QString pinTag;
        int pinType;
    };
    struct testCommand
    {
        int cmd;
        QString arg;
    };

    TestSheet(QString name, QString description, int numOfPins);
    TestSheet(QString fileName);

    QString getName() const;
    void setName(const QString &value);
    QString getDescription() const;
    void setDescription(const QString &value);
    int getNumOfPins() const;
    void setNumOfPins(int value);

    int saveToFile(QString fileName);
    QByteArray getPowerPins();
    QByteArray getGNDPins();

    //load from file
    //save to file
    QString initIO(bool visualization=false);
    QString compareStep(int step, QString data);

    QVector <pinDesignation> pins;
    QVector <testCommand> script;

    QStringList getPinsDescriptions();
    QString getFN();
private:
    QString name;
    QString description;
    int numOfPins;
    QString fileName;

};

#endif // TESTSHEET_H
