#include "editorwindow.h"
#include "ui_editorwindow.h"
#include "chord.h"
#include "chordinterpreter.h"

#include <QMessageBox>

EditorWindow::EditorWindow(chordInterpreter * interp, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::EditorWindow)
{
     ui->setupUi(this);

     //Mantle Tree view!

     this->interpreter=interp;
     this->workingBase=interp->getBase();
     this->visualizeTable();
     this->setWindowTitle("Chord editor");
}

void EditorWindow::visualizeTable()
{
    int selekted=ui->twCommandsList->currentRow();
    ui->twCommandsList->clear();
    for (int i=0;i<this->workingBase.count();i++)
    {
        ui->twCommandsList->addItem(this->workingBase.at(i).name);
    }
    ui->twCommandsList->setCurrentRow(selekted);
}

EditorWindow::~EditorWindow()
{
    delete ui;
}


void EditorWindow::on_twCommandsList_currentRowChanged(int currentRow)
{
    //SAVE PREVIOUS ROW!
    if (ui->twCommandsList->currentRow()>-1)
    {
        ui->leName->setText(this->workingBase.at(currentRow).name);
        ui->leChord->setText(this->workingBase.at(currentRow).combo);
        ui->leCommand->setText(this->workingBase.at(currentRow).command);
        ui->btnRec->setEnabled(1);
    }
    else
    {
        ui->leName->clear();
        ui->leChord->clear();
        ui->leCommand->clear();
        ui->btnRec->setEnabled(0);
    }
    ui->btnApply->setEnabled(0);
}

void EditorWindow::on_btnRemove_clicked()
{
    if (ui->twCommandsList->currentRow()>-1)
    {
        this->workingBase.removeAt(ui->twCommandsList->currentRow());
        ui->twCommandsList->setCurrentRow(ui->twCommandsList->currentRow()-1);
        this->visualizeTable();
    }
}

void EditorWindow::on_btnAdd_clicked()
{
    chord x;
    x.name="NEW";
    x.combo="";
    x.command="";
    this->workingBase.append(x);
    visualizeTable();
    ui->twCommandsList->setCurrentRow(ui->twCommandsList->count()-1);
}

void EditorWindow::on_btnApply_clicked()
{
    if ((ui->leName->text()=="")||(ui->leCommand->text()=="")||(ui->leChord->text()==""))
    {
        QMessageBox::information(this,"Error","No fields should be blank!");
        return;
    }
    for (int i=0;i<this->workingBase.count();i++)
    {
        if ((this->workingBase.at(i).combo==ui->leChord->text().trimmed())&&
                (i!=ui->twCommandsList->currentRow()))
        {
            QMessageBox::information(this,"Error","Chord the same as "+this->workingBase.at(i).name+"!");
            return;
        }
    }
    chord x;
    x.name=ui->leName->text();
    x.combo=ui->leChord->text();
    x.command=ui->leCommand->text();
    this->workingBase.replace(ui->twCommandsList->currentRow(),x);
    visualizeTable();
    ui->btnApply->setEnabled(0);
}

void EditorWindow::on_leName_textChanged()
{
    ui->btnApply->setEnabled(1);
}

void EditorWindow::on_leChord_textChanged()
{
    ui->btnApply->setEnabled(1);
}

void EditorWindow::on_leCommand_textChanged()
{
    ui->btnApply->setEnabled(1);
}

void EditorWindow::on_EditorWindow_accepted()
{
    this->interpreter->changeBase(this->workingBase);
    this->interpreter->saveToFile();
}

void EditorWindow::on_btnRec_clicked()
{
    ui->leChord->setFocus();
    this->interpreter->recordKeystrokes(ui->leChord);
}

