#ifndef CHORDINTERPRETER_H
#define CHORDINTERPRETER_H

#include <QString>
#include <QList>
#include <QPlainTextEdit>
#include <QLineEdit>
#include "chord.h"
#include <QTimer>

class chordInterpreter
{
public:

    chordInterpreter(QList<chord> database, QPlainTextEdit * debugLog);
    void changeBase(QList<chord> database);
    void loadFromFile(QString name);
    void setDebugLevel(int level);
    void stuffKey(QString key);
    void setTrainingMode(bool);

    QList<chord> getBase();
    void saveToFile();

    void recordKeystrokes(QLineEdit * le);
private:
    QString fileName;
    QString currentCombo;
    QList<chord> database;
    bool trainingMode;
    QPlainTextEdit * debugLog;
    int debugLevel;

    void addDebug(int level, QString message);
    bool recording;
    QLineEdit * recorder;
//signals:

};

#endif // CHORDINTERPRETER_H
